
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP | CLK_FILTER_LINEAR;
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L)*2.0f)))

static vec4 INPUT(image2d_t src_data, vec2 tc, __global FilterParam* param)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc ).zyxw;
}


vec3 AdjustforJigsaw_Spring(vec3 rgb) // YELLOW
{
	vec3 output;
	output.x = ChannelBlend_Exclusion(rgb.x,86.0f/256.0f);
	output.y = ChannelBlend_Exclusion(rgb.y,2.0f/256.0f);
	output.z = ChannelBlend_Exclusion(rgb.z,2.0f/256.0f);
	return output;
}
vec3 AdjustforJigsaw_Summer(vec3 rgb) //purple
{
	vec3 output;
	output.x= ChannelBlend_Exclusion(rgb.x, 21.0f/256.0f);
	output.y = ChannelBlend_Exclusion(rgb.y, 59.0f/256.0f);
	output.z = ChannelBlend_Exclusion(rgb.z, 7.0f/256.0f);
	return output;
}

vec3 AdjustforJigsaw_Autumn(vec3 rgb) // BLUE
{
	vec3 output;
	output.x = ChannelBlend_Exclusion(rgb.x, 16.0f/256.0f);
	output.y = ChannelBlend_Exclusion(rgb.y, 5.0f/256.0f);
	output.z = ChannelBlend_Exclusion(rgb.z, 99.0f/256.0f);
	return output;
}
vec3 AdjustforJigsaw_Winter(vec3 rgb) //copper
{
	vec3 output;
	output.x = ChannelBlend_Exclusion(rgb.x, 9.0f/256.0f);
	output.y = ChannelBlend_Exclusion(rgb.y, 62.0f/256.0f);
	output.z = ChannelBlend_Exclusion(rgb.z, 103.0f/256.0f);
	return output;
}

__kernel  void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
	  __global FilterParam* param,
	  int alpha) // alpah 0 - 100
{	

	int W = get_global_size(0);
	int H = get_global_size(1);
	int w = get_global_id0( param);
	int h = get_global_id1( param);
	float2 resolution = (float2)(W,H);
	float2 iResolution = resolution;
	int2 coordinate = (int2)(get_global_id0( param), get_global_id1( param));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	vec2 tc = uv;
	
	// Get the images
	vec4 col;
	vec4 inColor = INPUT( src_data, (vec2)(uv.x, uv.y) , param);
	
	float whiteGap = 0.00325f;
	float colorGapX = 0.33125f;
	float colorGapX2 = 2.0f*colorGapX;
	float whiteGapY = whiteGap*W/H;
	float colorGapY = (1.0f - whiteGapY)/2.0f;
	vec3 temp; 
	
	col.xyz =AdjustforJigsaw_Summer(inColor.xyz);

	uv = (vec2)(uv.x, 1.0f - uv.y);
	if( uv.y >  0.605898f && uv.x > 0.318318f)
		col.xyz = (vec3)(1.0f); 
	if( uv.y >  0.605898f + whiteGapY && uv.x > 0.318318f + whiteGap)
		col.xyz = AdjustforJigsaw_Winter(inColor.xyz); 
	if( uv.y >  0.605898f&& uv.x > 0.318318f - whiteGap && uv.x < 0.318318f )
	{
		temp = (vec3)(0.6f/whiteGap*(uv.x - 0.318318f + whiteGap) + 0.1f);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}
	
	
	if( uv.x >  0.4474f && uv.y < 0.654f)
		col.xyz = (vec3)(1.0f); 
	if( uv.x > 0.4474f + whiteGap && uv.y < 0.654f - whiteGapY)
		col.xyz = AdjustforJigsaw_Spring(inColor.xyz); 
	if(  uv.x < 0.4474f && uv.x > 0.4474f -  whiteGap  && uv.y < 0.654f)
	{
		temp = (vec3)(0.6f/whiteGap*(uv.x -  0.4474f + whiteGap) + 0.1f);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}
	
	if( uv.y <  0.4210526f && uv.x < 0.465035f)
		col.xyz = (vec3)(1.0f); 
	if( uv.y <  0.4210526f - whiteGapY && uv.x < 0.465035f - whiteGap)
		col.xyz = AdjustforJigsaw_Autumn(inColor.xyz); 
	if( uv.y <  0.4210526f && uv.x > 0.465035f && uv.x < 0.465035f + whiteGap)
	{
		temp = (vec3)(-0.6f/whiteGap*(uv.x - 0.465035f - whiteGap) + 0.1f);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}
	col.w = inColor.w; 
	write_imagef(dest_data, (int2)(get_global_id(0), get_global_id(1)), inColor.zyxw*(1.0f - alpha/100.0f) + col.zyxw*alpha/100.0f);
	
}

